/* eslint react/forbid-component-props: 0 */

import React from 'react';
import axios from 'axios';
import PropTypes from 'prop-types';

import { YSpin } from 'y-components';

import Progress from '../GroupsManager/List/Item/Progress';

class OwnerInfo extends React.Component {
    static getUrl(owner) {
        return (owner.toLowerCase() === owner ? '/api/v1.0/user/' : '/api/v1.0/group/') + encodeURIComponent(owner);
    }

    constructor(props) {
        super(props);

        this.state = {
            isLoading: true,
            hasError: false
        };
    }

    componentDidMount() {
        const self = this;
        const owner = this.props.owner;

        if (owner) {
            axios.get(OwnerInfo.getUrl(owner))
                .then(response => {
                    const data = response.data;

                    if (data) {
                        self.setState({
                            isLoading: false,
                            hasError: false,
                            data
                        });
                    } else {
                        self.setState({
                            isLoading: false,
                            hasError: false,
                            data: {}
                        });
                    }
                })
                .catch(error => {
                    self.setState({
                        isLoading: false,
                        hasError: true,
                        error
                    });
                });
        }
    }

    render() {
        /* eslint complexity: [1, 15] */
        const owner = this.props.owner;
        const namespace = this.props.namespace;
        const slim = this.props.slim;
        const data = this.state.data || {};
        const isLoading = this.state.isLoading && !this.state.hasError;
        const needInfo = data.quota && data.quota.limit && data.quota.consumption;

        return (
            <div className={'semaphore__link-wrap'}>
                <a href={`/${namespace}?page=1&pageCapacity=20&order=-updated&owner=${owner}`} className="user-login">{owner}</a>
                {
                    isLoading ?
                        <YSpin progress size="xxs"/> :
                        needInfo && <Progress
                            quota={data.quota}
                            float={'right'}
                            slim={slim}
                            name={owner}
                            namespace={namespace}
                            />
                }
            </div>
        );
    }
}

OwnerInfo.propTypes = {
    owner: PropTypes.string,
    namespace: PropTypes.string,
    slim: PropTypes.bool
};

module.exports = OwnerInfo;
