import React, { Component } from 'react';
import cookie from 'bemmy/src/blocks/component/cookie';
import { setCookieWithExpire } from '../../../helpers/utils/cookie';

import { YCheckbox, YSelect, YOption } from 'y-components';

class AutoupdateToggler extends Component {
    constructor(props) {
        super(props);

        this._namespace = 'autoupdatePreference';

        const value = cookie.get(this._namespace) || '';

        this.state = {
            isEnabled: Boolean(value),
            value: Number(value)
        };

        this.handleToggleEnabled = this.handleToggleEnabled.bind(this);
        this.handleValueChange = this.handleValueChange.bind(this);
    }

    handleToggleEnabled(e) {
        const isEnabled = e.target.checked;

        if (isEnabled) {
            setCookieWithExpire(this._namespace, 3, 365);
        } else {
            setCookieWithExpire(this._namespace, '', -1);
        }

        this.setState({
            isEnabled,
            value: 3
        });
    }

    handleValueChange(e) {
        setCookieWithExpire(this._namespace, e.target.value, 365);
    }

    renderSelector() {
        const { value } = this.state;
        return (
            <div>
                <YSelect
                    size="s"
                    theme="normal"
                    rows={6}
                    onChange={this.handleValueChange}
                    name={name}
                    >
                    {
                        [3, 5, 10, 20, 30, 60]
                            .map((val, i) => (
                                <YOption
                                    key={i}
                                    value={val}
                                    selected={val === value}
                                    >
                                    {`${val}s`}
                                </YOption>
                            ))
                    }
                </YSelect>
            </div>
        );
    }

    render() {
        const { isEnabled } = this.state;

        return (
            <div>
                <YCheckbox
                    size="s"
                    checked={isEnabled}
                    name="cat-spinner"
                    onChange={this.handleToggleEnabled}
                    >
                    Enable autoupdate
                </YCheckbox>

                { isEnabled && this.renderSelector() }
            </div>
        );
    }
}

module.exports = AutoupdateToggler;
