import React, { Component } from 'react';
import PropTypes from 'prop-types';
import b_ from 'b_';

import { YSelect, YOption } from 'y-components';

class InterfaceSelector extends Component {
    constructor(props) {
        super(props);

        this.state = {
            value: ''
        };

        this._block = b_.with('interface');

        this.handleValueChange = this.handleValueChange.bind(this);
    }

    componentDidMount() {
        this.props.fetchPreferences();
    }

    componentWillReceiveProps(nextProps) {
        if (nextProps.prefs && nextProps.prefs.interface === 'new' &&
            this.props.prefs && this.props.prefs.interface !== nextProps.prefs.interface) {
            window.location.reload();
        }
    }

    handleValueChange(e) {
        const { prefs = {}} = this.props;

        const nextPrefs = Object.assign({}, prefs, { interface: e.target.value });

        this.props.putPreferences(nextPrefs);
    }

    render() {
        const { value } = this.state;
        const { prefs = {}} = this.props;

        return (
            <div className={this._block()}>
                <YSelect
                    size="s"
                    theme="normal"
                    rows={6}
                    onChange={this.handleValueChange}
                    name={'interface'}
                    >
                    {
                        ['new', 'old']
                            .map((val, i) => (
                                <YOption
                                    key={i}
                                    value={val}
                                    selected={val === value || val === prefs.interface}
                                    >
                                    {val}
                                </YOption>
                            ))
                    }
                </YSelect>
                <span className={this._block('label')}>Interface</span>
            </div>
        );
    }
}

InterfaceSelector.propTypes = {
    fetchPreferences: PropTypes.func,
    putPreferences: PropTypes.func,
    prefs: PropTypes.object
};

module.exports = InterfaceSelector;
