import { connect } from 'react-redux';

import InterfaceSelector from './InterfaceSelector';

import API from '../../../api';

function mapStateToProps(state) {
    return {
        prefs: state.user.prefs
    };
}

function mapDispatchToProps(dispatch) {
    return {
        fetchPreferences: () => dispatch(API.user.fetchPreferences()),
        putPreferences: payload => dispatch(API.user.putPreferences(payload))
    };
}

module.exports = connect(mapStateToProps, mapDispatchToProps)(InterfaceSelector);
