import React, { Component } from 'react';
import b_ from 'b_';
import cookie from 'bemmy/src/blocks/component/cookie';
import { setCookieWithExpire } from '../../helpers/utils/cookie';

import { YCheckbox } from 'y-components';

import AutoupdateToggler from './AutoupdateToggler';
import InterfaceSelector from './InterfaceSelector';

class PreferencesWrapper extends Component {
    constructor(props) {
        super(props);

        this.state = {
            catSpinner: cookie.get('catSpinnerPreference') === '1'
        };

        this._block = b_.with('preferences');
        this.handleCatSpinnerPreferenceChange = this.handleCatSpinnerPreferenceChange.bind(this);
    }

    handleCatSpinnerPreferenceChange(e) {
        setCookieWithExpire('catSpinnerPreference', e.target.checked ? 1 : 0, 365);

        this.setState({
            catSpinner: e.target.checked
        });

        [].map.call(document.querySelectorAll('.loader__in'), el => {
            if (e.target.checked) {
                el.classList.add('loader__cat');
            } else {
                el.classList.remove('loader__cat');
            }
        });
    }

    render() {
        return (
            <div className={this._block()}>
                <div className={this._block('item')}>
                    <h2 className={this._block('title')}>Preferences</h2>
                    <InterfaceSelector/>
                    <div>
                        <YCheckbox
                            size="s"
                            checked={this.state.catSpinner}
                            name="cat-spinner"
                            onChange={this.handleCatSpinnerPreferenceChange}
                            >
                            Enable cat spinner
                        </YCheckbox>
                    </div>
                    <AutoupdateToggler/>
                </div>
            </div>
        );
    }
}

module.exports = PreferencesWrapper;
