import React from 'react';
import b_ from 'b_';
import axios from 'axios';
import cookie from 'bemmy/src/blocks/component/cookie';

import { YButton } from 'y-components';

const STORAGE_KEY = 'new_ui_disabled';
const PREFERENCES_URL = '/api/v1.0/user/current/preferences/prefs';

class NewUIPromo extends React.PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            visible: false,
            prefs: {}
        };

        this.block = b_.with('new-ui-promo');

        this.handleEnableNewDesign = this.handleEnableNewDesign.bind(this);
        this.handleDisableNewDesign = this.handleDisableNewDesign.bind(this);
        this.handleSetDontShowAgain = this.handleSetDontShowAgain.bind(this);
    }

    componentDidMount() {
        if (!cookie.get(STORAGE_KEY) && !window.promoInited) {
            const that = this;

            window.promoInited = true;

            axios
                .get(PREFERENCES_URL)
                .then(function (response) {
                    const prefs = Object.assign({}, response ? response.data || {} : {}, { interface: 'new' });

                    that.setState({ prefs: prefs });
                })
                .catch(function () {
                    that.setState({
                        prefs: {
                            interface: 'new'
                        }
                    });
                });

            setTimeout(this.handleShow.bind(this), 5000);
        }
    }

    componentWillUnmount() {
        clearTimeout(this.timeout);
    }

    handleShow() {
        this.setState({ visible: true });
    }

    handleHide() {
        this.setState({ visible: false });
    }

    handleSetPreference() {
        axios
            .put(PREFERENCES_URL, this.state.prefs)
            .then(function () {
                window.location.reload();
            });
    }

    handleSetDontShowAgain() {
        const today = new Date();
        const expire = new Date();
        expire.setTime(today.getTime() + 3600000 * 24 * 7);

        document.cookie = STORAGE_KEY + '=1;expires=' + expire.toGMTString() + ';path=/;';
    }

    handleEnableNewDesign() {
        this.handleHide();
        this.handleSetDontShowAgain();
        this.handleSetPreference();
    }

    handleDisableNewDesign() {
        this.handleHide();
        this.handleSetDontShowAgain();
    }

    render() {
        const { visible } = this.state;

        return (
            <div className={this.block({ visible })}>
                <div className={this.block('title')}>
                    We completely redesigned interface of Sandbox. It became faster and more beautiful. Try it.
                    </div>
                <div className={this.block('hint')}>This action is invertible at profile settings in the future.</div>
                <div className={this.block('controls')}>
                    <YButton
                        mix={this.block('handler')}
                        theme={'action'}
                        size={'s'}
                        onClick={this.handleEnableNewDesign}
                    >
                        I'd like to enable
                        </YButton>
                    <YButton
                        mix={this.block('handler')}
                        theme={'pseudo'}
                        size={'s'}
                        onClick={this.handleDisableNewDesign}
                    >
                        Don't irritate me
                        </YButton>
                </div>
            </div>
        );
    }
}

module.exports = NewUIPromo;
