/* eslint camelcase: 0 */
/* eslint react/no-danger: 0 */

import React from 'react';
import createReactClass from 'create-react-class';
import propTypes from 'prop-types';
import { connect } from 'react-redux';
import { get } from 'lodash';

import backboneMixin from '../utils/react.backbone';

import TabContentWrapper from '../TabContentWrapper';
import { YSpin } from 'y-components';

import api from '../../api/tasks';

const ReportTab = createReactClass({
    propTypes: {
        model: propTypes.object.isRequired // eslint-disable-line
    },

    mixins: [backboneMixin],

    updateOnProps: { model: 'model' },

    componentDidMount() {
        if (!this.props.report) {
            this.fetchData();
        }
    },

    componentWillReceiveProps(newProps) {
        if (newProps.action !== this.props.action && !newProps.report) {
            this.fetchData(true, newProps);
        }
    },

    fetchData(force, newProps) {
        const props = newProps || this.props;
        const reports = props.model.get('reports');
        const reportName = this._getAction(props);

        const fetchableReport = reports && reports.filter(report => {
            return report.label === reportName;
        })[0];

        if (fetchableReport) {
            props.fetchTaskReport({
                taskId: props.model.get('id'),
                name: reportName,
                url: fetchableReport.url
            });
        }
    },

    _getAction(props) {
        const reportName = (props && props.action) || this.props.action;

        return reportName && reportName.replace('report-', '');
    },

    render() {
        const content = this.props.report;
        const isLoading = content && content.isLoading;

        return (
            <TabContentWrapper>
                {
                    isLoading ?
                        <YSpin progress size="xxs"/> :
                        <div dangerouslySetInnerHTML={{ __html: content }}/>
                }
            </TabContentWrapper>
        );
    }
});

function mapStateToProps(state, props) {
    const task = props.model;
    const action = ((props && props.action) || this.props.action).replace('report-', '');

    const report = get(state, ['tasks', String(task.get('id')), 'reports', action]);

    return { report };
}

function mapDispatchToProps(dispatch) {
    return {
        fetchTaskReport(params) {
            return dispatch(api.fetchTaskReport(params));
        }
    };
}

module.exports = connect(mapStateToProps, mapDispatchToProps)(ReportTab);
