/* eslint react/forbid-component-props: 0 */

import React from 'react';
import axios from 'axios';
import styled from 'styled-components';
import PropTypes from 'prop-types';

import { YSpin, YPopup } from 'y-components';

const I = styled.i`
    margin-right: 5px;
`;

import router from '../../../router';

class SemaphoreLink extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            isLoading: true,
            popupVisible: false,
            hasError: false,
            popupTrg: undefined
        };

        this.handleSemaphoreClick = this.handleSemaphoreClick.bind(this);
        this.handleShowPopup = this.handleShowPopup.bind(this);
        this.handleClosePopup = this.handleClosePopup.bind(this);
        this.handlePopupTarget = this.handlePopupTarget.bind(this);
    }

    componentDidMount() {
        const self = this;
        const item = this.props.item;

        if (item && item.name && !this.state.data) {
            axios.get('/api/v1.0/semaphore?limit=1&name=' + encodeURIComponent(item.name))
                .then(response => {
                    const data = response && response.data && response.data.items && response.data.items[0];

                    if (data) {
                        self.setState({
                            isLoading: false,
                            hasError: false,
                            data
                        });
                    } else {
                        self.setState({
                            isLoading: false,
                            hasError: false,
                            data: {}
                        });
                    }
                })
                .catch(error => {
                    self.setState({
                        isLoading: false,
                        hasError: true,
                        error
                    });
                });
        }
    }

    handleSemaphoreClick(event) {
        event.preventDefault();

        const url = event.currentTarget.getAttribute('href');

        router.navigate(url, { trigger: true });

        this.setState({ popupVisible: false });
    }

    handleShowPopup() {
        this.setState({ popupVisible: true });
    }

    handleClosePopup() {
        this.setState({ popupVisible: false });
    }

    handlePopupTarget(c) {
        this.setState({ popupTrg: c });
    }

    render() {
        /* eslint complexity: [1, 15] */
        const data = this.state.data || {};
        const isLoading = this.state.isLoading && !this.state.hasError;
        const bulbClass = 'fa fa-lightbulb-o ' +
            ((data.value || 0) + this.props.item.weight < (data.capacity || 0) ?
                'fa_color_green' :
                'fa_color_red');

        if (isLoading) {
            return <YSpin progress size="xxs"/>;
        }

        return (<div className={'semaphore__link-wrap'}>
            {
                this.props.status === 'ENQUEUED' ?
                    <I className={bulbClass}/> :
                    null
            }
            {
                data.name ?
                    <a
                        className={'link'}
                        href={`/admin/semaphores/${data.id || ''}/view`}
                        onClick={this.handleSemaphoreClick}
                        onMouseEnter={this.handleShowPopup}
                        onMouseOut={this.handleClosePopup}
                        ref={this.handlePopupTarget}
                        >
                        {data && data.name}
                    </a> :
                    <span
                        onMouseEnter={this.handleShowPopup}
                        onMouseOut={this.handleClosePopup}
                        ref={this.handlePopupTarget}
                        >
                        {this.props.item.name}
                    </span>
            }
            <YPopup
                target={this.state.popupTrg}
                visible={this.state.popupVisible}
                directions={['bottom-left']}
                mainOffset={5}
                mix={'y-popup_type_padded'}
                >
                { data.value ? <div>{`Semaphore: ${data.value || 0}/${data.capacity || 0}`}</div> : null }
                <div>{`Weight: ${this.props.item.weight}`}</div>
                { this.props.item.capacity ? <div>{`Capacity: ${this.props.item.capacity}`}</div> : null }
            </YPopup>
        </div>);
    }
}

SemaphoreLink.propTypes = {
    item: PropTypes.object,
    status: PropTypes.string
};

module.exports = SemaphoreLink;
