const React = require('react');
const createReactClass = require('create-react-class');
const propTypes = require('prop-types');

const backboneMixin = require('../utils/react.backbone');

const StatusGroup = require('../StatusGroup');
const AsideWrapper = require('../AsideBlockWrapper');

const SemaphoreLink = require('./SemaphoreLink');

const SemaphoreInfo = createReactClass({
    propTypes: {
        model: propTypes.object.isRequired // eslint-disable-line
    },

    mixins: [backboneMixin],

    updateOnProps: { model: 'model' },

    render() {
        const model = this.props.model;
        const requirements = model && model.get('requirements');
        const semaphores = requirements && requirements.semaphores;
        const status = model.get('status');

        const acquires = semaphores ? semaphores.acquires : [];
        const releases = semaphores ? semaphores.release : [];

        if (!(acquires.length)) {
            return (
                <AsideWrapper title={'Semaphores'} clean>
                    <span className="icon icon_minus"/>
                </AsideWrapper>
            );
        }

        return (
            <AsideWrapper title={'Semaphores'} clean>
                {
                    acquires.map((item, i) => {
                        return <SemaphoreLink item={item} status={status} key={i}/>;
                    })
                }
                <StatusGroup title="Release in" statuses={releases}/>
            </AsideWrapper>
        );
    }
});

module.exports = SemaphoreInfo;
