/* eslint camelcase: 0 */

import React, { Component } from 'react';
import propTypes from 'prop-types';
import styled from 'styled-components';

import { YSpin } from 'y-components';
import StatusLabel from '../../StatusLabel';
import Controls from '../../SemaphoresManager/List/Item/Controls';

import clipboardClientMixin from '../../../views/components/clipboardClient/ClipboardClientMixin';

const Icon = styled.span`
    opacity: .7;
`;

const ControlsWrap = styled.div`
    display: inline-block;
    position: absolute;
    right: 20px;

    button {
        margin: -1px;
    }
`;

const Button = styled.button`
    margin: -1px;
    border-radius: 0;
    font-family: Arial,Helvetica,sans-serif;
    font-size: 13px;
    line-height: 26px;
    user-select: none;
    box-sizing: border-box;
    display: inline-block;
    vertical-align: middle;
    position: relative;
    text-align: left;
    background-color: #fff;
    padding: 0;
    margin: 0;
    transition: border-color .1s ease-out,background .1s ease-out;
    border: 1px solid rgba(0,0,0,.2);
    z-index: 2;
    text-decoration: none;
    color: inherit;
    cursor: pointer;

    .button__icon {
        width: 32px;
        position: absolute;
        left: 0;
        top: 0;
        bottom: 0;
        z-index: 2;
        background: center center no-repeat;
    }

    .button__label {
        margin-left: 30px;
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
        max-width: 100%;
        display: block;
        padding: 0 13px 0 0;
    }

    ${props => {
        if (props.direction === 'left') {
            return `
                border-bottom-left-radius: 3px;
                border-top-left-radius: 3px;
            `;
        }
        if (props.direction === 'right') {
            return `
                border-bottom-right-radius: 3px;
                border-top-right-radius: 3px;
            `;
        }
    }}
`;

class SemaphoreTitle extends Component {
    componentDidMount() {
        clipboardClientMixin.initializeClipboardClient(
            '.id-proxy-copier',
            'ID has been copied to clipboard.'
        );
    }

    render() {
        const { semaphore, onRemoveSemaphore, onPushSemaphore } = this.props;
        const isLoading = !semaphore.name;
        const isAdmin = semaphore.rights === 'write';

        return (
            isLoading ?
                <YSpin progress size="xxs"/> :
                (<div>
                    <div className="semaphore__header">
                        <div className="semaphore__header-item">
                            <h4 className="title title_slim title_console taskview_task_type">
                                {semaphore.name}
                            </h4>
                        </div>
                        <div className="semaphore__header-item">
                            <StatusLabel status={semaphore.auto ? 'Auto' : 'Persistent'}/>
                        </div>
                        <div className="semaphore__header-item">
                            <span className="section__title__id">#{semaphore.id}</span>&nbsp;
                            <Icon
                                className="link external fa fa-files-o id-proxy-copier" // eslint-disable-line
                                data-clipboard-text={semaphore.id}
                                />
                            {
                                isAdmin && <ControlsWrap>
                                    <Controls
                                        data={semaphore}
                                        onSubmitRemoving={onRemoveSemaphore}
                                        onPushSemaphore={onPushSemaphore}
                                        editLabel={
                                            <Button direction={'left'}>
                                                <span
                                                    className="button__icon"
                                                    style={{
                                                        backgroundImage: `url(${baseUrl}/images/icons/pencil-icon.svg)`,
                                                        backgroundSize: '16px'
                                                    }}
                                                    title="Edit"
                                                    />
                                                <span className="button__label">Edit</span>
                                            </Button>
                                        }
                                        removeLabel={
                                            <Button direction={'right'}>
                                                <span
                                                    className="button__icon"
                                                    style={{
                                                        backgroundImage: `url(${baseUrl}/images/icons/trash.svg)`
                                                    }}
                                                    title="Remove"
                                                    />
                                                <span className="button__label">Remove</span>
                                            </Button>
                                        }
                                        />
                                </ControlsWrap>
                            }
                        </div>
                    </div>
                </div>)
        );
    }
}

SemaphoreTitle.propTypes = {
    semaphore: propTypes.object,
    onRemoveSemaphore: propTypes.func,
    onPushSemaphore: propTypes.func
};

SemaphoreTitle.defaultProps = {
    onRemoveSemaphore: () => {},
    onPushSemaphore: () => {}
};

module.exports = SemaphoreTitle;
