/* eslint camelcase: 0 */

import React, { Component } from 'react';
import propTypes from 'prop-types';
import styled from 'styled-components';

import Timer from '../../../helpers/utils/Timer';

import { YSpin } from 'y-components';
import UserLogin from '../../UserLogin';
const IFrame = styled.iframe`
    border: 0;
    margin-top: 35px;
`;

class SemaphoreView extends Component {
    formatTime(field) {
        const { semaphore } = this.props;
        const time = Timer.serializeTimeMark(semaphore.time[field]);

        return <span>{`${time.date} ${time.time} `}(<span className="gray">{time.comment}</span>)</span>;
    }

    formatShared() {
        const { semaphore } = this.props;
        const shared = semaphore.shared || [];

        return shared.length ?
            shared.map((user, i) => {
                return <UserLogin login={user} key={i}/>;
            }) : '–';
    }

    formatMetricsLink() {
        const { semaphore } = this.props;
        const url = semaphore.statistics_url;

        if (url) {
            return url + '&graph=auto&b=1h&e=&stack=false&graphOnly=y&autorefresh=y';
        }

        return '';
    }

    getData() {
        const { semaphore } = this.props;

        return [
            {
                name: 'Type',
                value: semaphore.auto ? 'Auto' : 'Persistent'
            },
            {
                name: 'Name',
                value: semaphore.name
            },
            {
                name: 'Owner',
                value: <UserLogin login={semaphore.owner}/>
            },
            {
                name: 'Shared with',
                value: this.formatShared()
            },
            {
                name: 'Value',
                value: semaphore.value
            },
            {
                name: 'Capacity',
                value: semaphore.capacity
            },
            {
                name: 'Created',
                value: this.formatTime('created')
            },
            {
                name: 'Updated',
                value: this.formatTime('updated')
            }
        ];
    }

    render() {
        const { semaphore } = this.props;
        const isLoading = semaphore && !semaphore.name;
        const link = this.formatMetricsLink();

        return (
            <div className="section__i-clean">
                {
                    isLoading ?
                        <YSpin progress size="xxs"/> :
                        (<div>
                            <h4 className="monitor__t">Parameters</h4>
                            <div className="monitor__b">
                                <table className="t t_max t_nobd">
                                    <tbody>
                                        {
                                            this.getData().map((item, i) => {
                                                return (<tr key={i}>
                                                    <td>{item.name}</td>
                                                    <td>{item.value}</td>
                                                </tr>);
                                            })
                                        }
                                    </tbody>
                                </table>
                            </div>
                            {
                                link ? <IFrame height="350" width="700" src={link}/> : null
                            }
                        </div>)
                }
            </div>);
    }
}

SemaphoreView.propTypes = {
    semaphore: propTypes.object.isRequired // eslint-disable-line
};

SemaphoreView.defaultProps = {
    semaphore: {}
};

module.exports = SemaphoreView;
