/* eslint camelcase: 0 */
/* eslint react/no-unused-prop-types: 0 */
import { get } from 'lodash';
import { connect } from 'react-redux';
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import styled from 'styled-components';

import api from '../../api/semaphores';
import router from '../../router';

import SemaphoreView from './SemaphoreView';
import SemaphoreTasks from './SemaphoreTasks';
import SemaphoreAudit from './SemaphoreAudit';
import SemaphoreTitle from './SemaphoreTitle';
import SubNavigation from '../SubNavigation';

const Wrap = styled.div`
    ${props => props.fade ? 'opacity: .5;' : ''}
`;

class SemaphoreWrapper extends Component {
    constructor() {
        super(...arguments);

        this.state = {
            activeTab: 0,
            alive: true
        };

        this.handleClickOnTab = this.handleClickOnTab.bind(this);
        this.handleRemoveSemaphore = this.handleRemoveSemaphore.bind(this);
        this.handlePushSemaphore = this.handlePushSemaphore.bind(this);
        this.getUrl = this.getUrl.bind(this);
        this.getTabs = this.getTabs.bind(this);
        this.navigate = this.navigate.bind(this);
        this.getContent = this.getContent.bind(this);
    }

    componentDidMount() {
        const activeTab = (this.getTabs() || []).findIndex(item => {
            return window.location.href.indexOf('/' + item.path) !== -1;
        });
        const existingTab = activeTab;

        this.navigate(existingTab);
        this.setState({ activeTab: existingTab === -1 ? 0 : existingTab });

        this.props.fetchSemaphoreById(this.props.id);
    }

    componentWillReceiveProps(newProps) {
        if (newProps.semaphore.name && !newProps.semaphore.isLoading && !this.state.alive) {
            this.setState({
                alive: true
            });
        }
    }

    handleRemoveSemaphore(group, id) {
        this.props.removeSemaphore(group, id);
        router.navigate('/admin/semaphores', { trigger: true });
    }

    handlePushSemaphore() {
        this.setState({
            alive: false
        });
    }

    handleClickOnTab(activeTab) {
        this.setState({ activeTab });
        this.navigate(activeTab);
    }

    navigate(activeTab) {
        if (activeTab === -1) {
            return;
        }

        const url = this.getUrl(activeTab);

        router.navigate(url, { trigger: false });
    }

    getUrl(activeTab) {
        const tab = this.getTabs()[activeTab];
        const url = '/admin/semaphores/' + this.props.pageProps.key + '/' + (tab ? tab.path : '');

        return url;
    }

    getTabs() {
        const { semaphore } = this.props;
        const { tasks = [] } = semaphore;

        return [
            {
                title: 'View',
                path: 'view'
            },
            {
                title: 'Acquired by tasks',
                path: 'tasks',
                active: Boolean(tasks.length),
                counters: tasks.length ? tasks.length : ''
            },
            {
                title: 'Audit',
                path: 'audit'
            }
        ];
    }

    getContent() {
        const { semaphore, id, isAdmin } = this.props;

        switch (this.state.activeTab) {
            case 2:
                return <SemaphoreAudit id={id} isAdmin={isAdmin}/>;
            case 1:
                return <SemaphoreTasks semaphore={semaphore}/>;
            case 0:
            default:
                return <SemaphoreView semaphore={semaphore}/>;
        }
    }

    render() {
        return (
            <Wrap fade={!this.state.alive}>
                <div className="section__i">
                    <SemaphoreTitle
                        semaphore={this.props.semaphore}
                        onRemoveSemaphore={this.handleRemoveSemaphore}
                        onPushSemaphore={this.handlePushSemaphore}
                        />
                    <SubNavigation tabs={this.getTabs()} active={this.state.activeTab} onClick={this.handleClickOnTab}/>
                </div>
                { this.getContent() }
            </Wrap>
        );
    }
}

SemaphoreWrapper.propTypes = {
    id: PropTypes.oneOfType([
        PropTypes.string,
        PropTypes.number
    ]),
    isAdmin: PropTypes.bool,
    activeTab: PropTypes.number,
    pageProps: PropTypes.object,
    semaphore: PropTypes.object,
    fetchSemaphoreById: PropTypes.func,
    removeSemaphore: PropTypes.func
};

SemaphoreWrapper.defaultProps = {
    pageProps: {},
    isAdmin: false
};

function mapStateToProps(state, props) {
    return {
        semaphore: get(state, ['semaphores', 'items', String(props.id)], { isEmpty: true })
    };
}

function mapDispatchToProps(dispatch) {
    return {
        fetchSemaphoreById: id => dispatch(api.fetchSemaphoreById(id)),
        removeSemaphore: (group, id) => dispatch(api.removeSemaphore(group, id))
    };
}

module.exports = connect(mapStateToProps, mapDispatchToProps)(SemaphoreWrapper);
