/* eslint react/forbid-component-props: 0 */
/* eslint max-len: 0 */

import React from 'react';
import styled from 'styled-components';
import PropTypes from 'prop-types';

import { connect } from 'react-redux';
import { get } from 'lodash';

import API from '../../../api';

import { YInput, YButton, YButtonGroup } from 'y-components';
import SuggestGroup from '../../Suggest/Group';

const Table = styled.table`
    width: 100%;
`;
const Td = styled.td`
    padding-right: 10px;

    .y-button-group {
        padding: 0 5px;
    }

    ${props => {
        if (props.right) {
            return `
                .y-button-group {
                    float: right;
                }
            `;
        }

        if (props.short) {
            return `
                width: 80px;
                .y-button-group {
                    padding: 0;
                }  
            `;
        }
    }}
`;
const InputWrap = styled.span`
    .y-input__control {
        border-right-width: 10px !important;
    }

    .y-input__clear {
        width: 26px;
        height: 26px;
        background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNCIgaGVpZ2h0PSIxNCI+PHBvbHlnb24gcG9pbnRzPSIxNCwwLjcgMTMuMywwIDcsNi4zIDAuNywwIDAsMC43IDYuMyw3IDAsMTMuMyAwLjcsMTQgNyw3LjcgMTMuMywxNCAxNCwxMy4zIDcuNyw3Ii8+PC9zdmc+Cg==);
    }
`;

class Filter extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            name: '',
            owner: '',
            shared: '',
            auto: []
        };

        this.handleChange = this.handleChange.bind(this);
        this.handleTypeChange = this.handleTypeChange.bind(this);
        this.handleApply = this.handleApply.bind(this);
        this.handleReset = this.handleReset.bind(this);
        this.handleToggleView = this.handleToggleView.bind(this);
    }

    componentDidMount() {
        if (!this.props.groups || this.props.groups.isLoading) {
            this.props.fetchGroupsList();
        }
    }

    handleChange(e) {
        if (this.state[e.target.name] !== e.target.value) {
            this.setState({ [e.target.name]: e.target.value });
        }
    }

    handleTypeChange(e, { value, name }) {
        const values = this.state[name];
        const index = values.indexOf(value);

        if (index !== -1) {
            return;
        }

        this.setState({ [name]: [value] });
    }

    handleToggleView(e) {
        this.props.setView(e.target.value);

        if (e.target.value === 'groups') {
            this.handleReset();
        } else {
            const params = Object.assign(this.state, { type: 'list' });

            this.props.onFilterChange(params);
        }
    }

    handleApply() {
        const params = Object.assign({}, this.state);

        if (params.auto.length && (params.auto[0] === 'auto' || params.auto[0] === 'persistent')) {
            params.auto = params.auto[0] === 'auto';
        } else {
            delete params.auto;
        }

        this.props.onFilterChange(params);
    }

    handleReset() {
        const flushedState = {
            name: '',
            owner: '',
            shared: '',
            auto: [],
            type: 'groups'
        };

        this.setState(flushedState, () => this.handleApply());
    }

    render() {
        return (<Table>
            <tbody>
                <tr>
                    <Td short>
                        <YButtonGroup
                            size="s"
                            name="auto"
                            values={[this.props.viewType]}
                            onChange={this.handleToggleView}
                            >
                            <YButton name="view" value="groups"><i className="fa fa-sitemap"/></YButton>
                            <YButton name="view" value="list"><i className="fa fa-list"/></YButton>
                        </YButtonGroup>
                    </Td>
                    <Td>
                        <InputWrap>
                            <YInput
                                size="s"
                                placeholder="Name"
                                name="name"
                                onChange={this.handleChange}
                                value={this.state.name}
                                />
                        </InputWrap>
                    </Td>
                    <Td>
                        <SuggestGroup
                            size="s"
                            placeholder="Owner"
                            name="owner"
                            onChange={this.handleChange}
                            value={this.state.owner}
                            data={this.props.groups}
                            />
                    </Td>
                    <Td>
                        <SuggestGroup
                            size="s"
                            placeholder="Shared with"
                            name="shared"
                            onChange={this.handleChange}
                            value={this.state.shared}
                            data={this.props.groups}
                            />
                    </Td>
                    <Td>
                        <YButtonGroup
                            size="s"
                            name="auto"
                            values={this.state.auto}
                            onChange={this.handleTypeChange}
                            >
                            <YButton name="auto" value="auto">Auto</YButton>
                            <YButton name="auto" value="persistent">Persistent</YButton>
                        </YButtonGroup>
                    </Td>
                    <Td right>
                        <YButtonGroup size="s">
                            <YButton onClick={this.handleApply}>Apply</YButton>
                            <YButton onClick={this.handleReset}>Reset</YButton>
                        </YButtonGroup>
                    </Td>
                </tr>
            </tbody>
        </Table>);
    }
}

Filter.propTypes = {
    groups: PropTypes.array,
    viewType: PropTypes.string,
    fetchGroupsList: PropTypes.func,
    onFilterChange: PropTypes.func,
    setView: PropTypes.func
};

function mapStateToProps(state) {
    return {
        groups: state.suggest.groups,
        viewType: get(state, ['user', 'configure', 'semaphores', 'view'], 'groups')
    };
}

function mapDispatchToProps(dispatch) {
    return {
        fetchGroupsList: () => dispatch(API.suggest.fetchGroupsList()),
        setView: value => dispatch(API.user.setConfig({
            namespace: 'semaphores',
            key: 'view',
            value
        }))
    };
}

module.exports = connect(mapStateToProps, mapDispatchToProps)(Filter);
