import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import styled from 'styled-components';

import { YSpin } from 'y-components';

const Wrapper = styled.div`
    padding: 7px 20px;
    box-shadow: #ebebeb 0px 1px 0px inset;
    background: #fff;
    color: #33c;
    cursor: pointer;
    user-select: none;
`;

const Angle = styled.span`
    .fa {
        width: 9px;
    }    

    margin-right: 10px;
    ${props => {
        if (props.level) {
            return `margin-left: ${(15 * (props.level - 1))}px`;
        }
    }}
`;

const LabelWrap = styled.div`
    display: inline-block;

    .y-spin {
        display: inline-block;
        width: 12px;
        height: 12px;
        margin-left: 5px;
        vertical-align: middle;
    }
`;

class Group extends PureComponent {
    constructor() {
        super(...arguments);

        this.state = {
            isExpanded: false
        };

        this.handleClick = this.handleClick.bind(this);
    }

    handleClick() {
        const { fetchSubtleGroup, name, groups, items } = this.props;
        const { isExpanded } = this.state;

        if (!isExpanded && !groups.length && !items.length) {
            fetchSubtleGroup(name);
        }

        this.setState({
            isExpanded: !this.state.isExpanded
        });
    }

    render() {
        const { name, isRoot, children, level, isLoading } = this.props;
        const { isExpanded } = this.state;
        const angleIconClass = `fa fa-angle-${isExpanded ? 'down' : 'right'}`;

        return (<div>
            { !isRoot && <Wrapper onClick={this.handleClick}>
                <Angle level={level}>
                    <i className={angleIconClass}/>
                </Angle>
                <LabelWrap>
                    {name}
                    { isLoading && <YSpin progress size={'xxs'}/>}
                </LabelWrap>
            </Wrapper> }
            { (isRoot || isExpanded) && <div>{children}</div> }
        </div>);
    }
}

Group.propTypes = {
    name: PropTypes.string,
    groups: PropTypes.array,
    items: PropTypes.array,
    level: PropTypes.number,
    isRoot: PropTypes.bool,
    children: PropTypes.any,
    isLoading: PropTypes.bool,
    fetchSubtleGroup: PropTypes.func
};

Group.defaultProps = {
    fetchSubtleGroup: () => {},
    items: [],
    groups: []
};

module.exports = Group;
