import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import styled from 'styled-components';

import i18n from '../../../../i18n';

import Confirm from '../../../../Confirm';
import GroupLogin from '../../../../GroupLogin';
import Edit from '../../../Edit';

const Name = styled.div`
    font-family: 'Ubuntu Mono', 'PT Mono', Consolas, monospace;
    margin: 10px 0;
`;

const Wrap = styled.div`
    margin: 15px 0;
`;

const ControlsWrap = styled.div`
    display: inline-block;
`;

const Cell = styled.span`
    width: 50%;
    display: inline-block;
    margin: 7px 0;
`;

class SemaphoresItemControls extends PureComponent {
    constructor() {
        super(...arguments);

        this.handleSubmitRemoving = this.handleSubmitRemoving.bind(this);
    }

    handleSubmitRemoving(id) {
        this.props.onSubmitRemoving(this.props.data.group, id);
    }

    render() {
        const { data, onPushSemaphore, editLabel, removeLabel } = this.props;

        if (data && data.rights === 'write') {
            return (<ControlsWrap>
                <Edit
                    label={editLabel}
                    onPushSemaphore={onPushSemaphore}
                    id={data.id}
                    />

                <Confirm
                    title={removeLabel}
                    submitLabel={i18n.common.remove}
                    id={data.id}
                    mix={'confirm__inline'}
                    onSubmit={this.handleSubmitRemoving}
                    >
                    <h3>{i18n.questions.removeSemaphore}</h3>
                    <Name>{data.name}</Name>
                    <Wrap>
                        <Cell>Owner</Cell>
                        <Cell><GroupLogin groups={data.owner} isLink/></Cell>
                        <Cell>Shared with</Cell>
                        <Cell><GroupLogin groups={data.shared} isLink/></Cell>
                        <Cell>Capacity</Cell>
                        <Cell>{data.capacity}</Cell>
                    </Wrap>
                </Confirm>
            </ControlsWrap>);
        }

        return null;
    }
}

SemaphoresItemControls.propTypes = {
    data: PropTypes.object,
    onSubmitRemoving: PropTypes.func,
    onPushSemaphore: PropTypes.func,
    editLabel: PropTypes.object,
    removeLabel: PropTypes.object
};

SemaphoresItemControls.defaultProps = {
    data: {},
    onPushSemaphore: () => {},
    editLabel: (
        <button className="button button_size_S button_type_clear button_icon-only_yes">
            <span
                className="button__icon"
                style={{
                    backgroundImage: `url(${baseUrl}/images/icons/pencil-icon.svg)`,
                    backgroundSize: '16px'
                }}
                title="Edit draft task"
                />
        </button>
    ),
    removeLabel: (
        <button className="button button_size_S button_type_clear button_icon-only_yes">
            <span
                className="button__icon"
                style={{
                    backgroundImage: `url(${baseUrl}/images/icons/x-mark-icon.svg)`,
                    backgroundSize: '16px'
                }}
                title="Remove scheduler"
                />
        </button>
    )
};

module.exports = SemaphoresItemControls;
