/* eslint react/forbid-component-props: 0 */

import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import styled from 'styled-components';

import Link from '../../../Link';
import GroupLogin from '../../../GroupLogin';
import StatusLabel from '../../../StatusLabel';
import Controls from './Controls';
import clipboardClientMixin from '../../../../views/components/clipboardClient/ClipboardClientMixin';

import { Name, Type, Owner, Shared, Value, Capacity, Edit } from '../../List';

const Wrapper = styled.div`
    display: inline-table;
    width: 100%;
    padding: 7px 20px;
    box-shadow: inset 0 1px 0 #EBEBEB;
    background: #fff;
    box-sizing: border-box;
    table-layout: fixed;

    :hover {
        background: #e5f4fe;

        .id-proxy-copier {
            opacity: 1;
        }
    }

    > div {
        display: table-cell;
    }

    ${props => props.isDeleting && 'opacity: 0.3'}
`;

const Icon = styled.span`
    margin-left: 5px;
    opacity: 0;
    transition: opacity .1s ease;
`;

class Item extends PureComponent {
    componentDidMount() {
        clipboardClientMixin.initializeClipboardClient(
            '.id-proxy-copier',
            'Name has been copied to clipboard.'
        );
    }

    render() {
        const { id, name, auto, owner, shared, value, capacity, removeSemaphore, isDeleting, level } = this.props;

        return (<Wrapper isDeleting={isDeleting}>
            <Name level={level}>
                <Link to={`/admin/semaphores/${id}/view`}>{name}</Link>
                <Icon
                    className="link external fa fa-files-o id-proxy-copier"
                    data-clipboard-text={name}
                    />
            </Name>
            <Type>{auto ? <StatusLabel status="auto"/> : null}</Type>
            <Owner><GroupLogin groups={owner} isLink/></Owner>
            <Shared><GroupLogin groups={shared} isLink/></Shared>
            <Value>{value}</Value>
            <Capacity>{capacity}</Capacity>
            <Edit>{!isDeleting && <Controls data={this.props} onSubmitRemoving={removeSemaphore}/>}</Edit>
        </Wrapper>);
    }
}

Item.propTypes = {
    name: PropTypes.string,
    id: PropTypes.number,
    auto: PropTypes.bool,
    owner: PropTypes.oneOfType([
        PropTypes.array,
        PropTypes.string
    ]),
    level: PropTypes.number,
    shared: PropTypes.array,
    value: PropTypes.number,
    capacity: PropTypes.number,
    isDeleting: PropTypes.bool,
    removeSemaphore: PropTypes.func
};

module.exports = Item;
