import React, { Component } from 'react';
import PropTypes from 'prop-types';
import styled from 'styled-components';

import { YButton, YModal } from 'y-components';

import i18n from '../../i18n';

const Navigation = styled.div`
    margin: -4px 0 12px;
`;

const Wrapper = styled.div`
    padding: 25px 30px 30px;
    min-width: 600px;
`;

const Controls = styled.div`
    display: flex;
    justify-content: space-between;
`;

const Title = styled.h3`
    font-family: Arial,Helvetica,sans-serif;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
    font-weight: 400;
    font-size: 24px;
    line-height: 28px;
    padding-bottom: 18px;
`;

const Content = styled.div`
    padding-bottom: 18px;
    font-size: 13px;
    line-height: 28px;
`;

class Modal extends Component {
    constructor(props) {
        super(props);

        this.state = {
            modalVisible: false
        };

        this.handleShowPopup = this.handleShowPopup.bind(this);
        this.handleShouldClose = this.handleShouldClose.bind(this);
        this.handleOkClick = this.handleOkClick.bind(this);
        this.getModal = this.getModal.bind(this);
    }

    getModal() {
        const { edit, title } = this.props;
        const _texts = i18n.admin.popup.semaphore;

        return (<YModal visible={this.state.modalVisible} onShouldClose={this.handleShouldClose}>
            <Wrapper>
                <Title>{title || _texts[edit ? 'edit' : 'create']}</Title>
                {
                    this.props.children ?
                        <Content>{this.props.children}</Content> :
                        null
                }
                <Controls>
                    <YButton onClick={this.handleOkClick} size="s" theme="action">
                        {_texts.controls[edit ? 'save' : 'create']}
                    </YButton>
                    <YButton onClick={this.handleShouldClose} size="s">
                        {_texts.controls.cancel}
                    </YButton>
                </Controls>
            </Wrapper>
        </YModal>);
    }

    handleShowPopup() {
        this.setState({
            modalVisible: true
        });
    }

    handleShouldClose() {
        this.setState({
            modalVisible: false
        });

        this.props.onCancel();
    }

    handleOkClick() {
        this.props.onSubmit();
        this.handleShouldClose();
    }

    render() {
        return (
            this.props.label ?
                <span>
                    <span onClick={this.handleShowPopup}>{this.props.label}</span>
                    {this.getModal()}
                </span> :
                <Navigation>
                    <span onClick={this.handleShowPopup}>
                        <YButton size="xs">
                            {i18n.admin.controls.create}
                        </YButton>
                    </span>
                    {this.getModal()}
                </Navigation>
        );
    }
}

Modal.propTypes = {
    title: PropTypes.string,
    children: PropTypes.any,
    onCancel: PropTypes.func,
    onSubmit: PropTypes.func,
    label: PropTypes.object,
    edit: PropTypes.bool
};

Modal.defaultProps = {
    onCancel: () => {},
    onSubmit: () => {},
    label: null,
    edit: false
};

module.exports = Modal;
