import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import API from '../../api';

import AdminNavigation from '../AdminNavigation';
import Headding from './Headding';
import List from './List';

class SemaphoreManager extends PureComponent {
    constructor(props) {
        super(props);

        this.handlePropsChange = this.handlePropsChange.bind(this);
    }

    handlePropsChange(data) {
        if (data.type === 'groups') {
            this.data = Object.assign({}, data);
        } else {
            this.data = Object.assign({}, this.data, data);
        }

        this.props.fetchSemaphoresList(this.data);
    }

    render() {
        return (<div>
            <AdminNavigation active={3}/>
            <Headding onFilterChange={this.handlePropsChange}/>
            <List onSortChange={this.handlePropsChange} onRangeChange={this.handlePropsChange}/>
        </div>);
    }
}

SemaphoreManager.propTypes = {
    fetchSemaphoresList: PropTypes.func
};

function mapDispatchToProps(dispatch) {
    return {
        fetchSemaphoresList(params) {
            return dispatch(API.semaphores.fetchSemaphoresList(params));
        }
    };
}

module.exports = connect(null, mapDispatchToProps)(SemaphoreManager);
