/* eslint react/no-unused-prop-types: 0 */

import React from 'react';
import PropTypes from 'prop-types';

import StatusLabel from '../StatusLabel';
import UserLogin from '../UserLogin';

class StatusGroup extends React.PureComponent {
    render() {
        const { statuses, notifications, title } = this.props;

        if (!statuses.length) {
            return null;
        }

        let _title = null;

        if (title) {
            _title = <div className="section__side__status-title">{title}</div>;
        }

        return (
            <div className="section__side__group">
                {_title}
                <div className="section__side__status">
                    {
                        statuses.map((status, i) => <StatusLabel key={i} status={status}/>)
                    }
                </div>
                {
                    (notifications.recipients || []).length && notifications.transport ?
                        <div className="section__side__row">
                            {notifications.transport}&nbsp;→&nbsp;
                            {notifications.recipients.map((user, i) => <UserLogin key={i} login={user}/>)}
                        </div> :
                        null
                }
            </div>
        );
    }
}

StatusGroup.propTypes = {
    statuses: PropTypes.array,
    notifications: PropTypes.object,
    title: PropTypes.string
};

StatusGroup.defaultProps = {
    statuses: [],
    notifications: {
        recipients: [],
        transport: ''
    }
};

module.exports = StatusGroup;
