import test from 'ava';
import React from 'react';
import { mount } from 'enzyme';

import StatusGroup from './index';

test('should not be rendered without any props', t => {
    const label = mount(<StatusGroup/>);

    t.is(label.type(), StatusGroup);
    t.is(label.html(), null);
});

test('should be rendered with custom statuses', t => {
    const label = mount(<StatusGroup statuses={['success', 'fail']}/>);

    t.is(label.type(), StatusGroup);
    t.is(label.find('.status').length, 2);
    t.is(label.find('.status_success').length, 1);
    t.is(label.find('.status_fail').length, 1);
    t.is(label.find('.section__side__status-title').length, 0);
    t.is(label.find('.section__side__row').length, 0);
});

test('should be rendered with title', t => {
    const label = mount(<StatusGroup statuses={['success', 'fail']} title={'Awesome title'}/>);

    t.is(label.type(), StatusGroup);

    const title = label.find('.section__side__status-title');

    t.is(title.length, 1);
    t.is(title.text(), 'Awesome title');
    t.is(label.find('.section__side__row').length, 0);
});

test('should be rendered with notifications', t => {
    const label = mount(<StatusGroup
        statuses={['success', 'fail']}
        notifications={{
            recipients: ['evilj0e', 'veto'],
            transport: 'email'
        }}
        />);

    t.is(label.type(), StatusGroup);

    const notifications = label.find('.section__side__row');

    t.is(notifications.length, 1);
    t.is(notifications.text().indexOf('email') !== -1, true);
    t.is(notifications.text().indexOf('evilj0e') !== -1, true);
    t.is(notifications.text().indexOf('veto') !== -1, true);
});

test('should be rendered with notifications', t => {
    let label = mount(<StatusGroup
        statuses={['success']}
        notifications={{ transport: 'email' }}
        />);

    t.is(label.type(), StatusGroup);
    t.is(label.find('.section__side__row').length, 0);

    label = mount(<StatusGroup
        statuses={['success']}
        notifications={{ recipients: ['evilj0e'] }}
        />);

    t.is(label.type(), StatusGroup);
    t.is(label.find('.section__side__row').length, 0);
});
