/* eslint camelcase: 0 */
/* eslint react/no-unused-prop-types: 0 */

import React from 'react';
import Styled from 'styled-components';
import PropTypes from 'prop-types';

const Div = Styled.div`${
    props => {
        if (props.type) {
            return 'border-top: 1px solid #e5e5e5; ' +
                'padding: 0 10px;' +
                'background: #fff;';
        }

        return 'margin-top: 0;' +
            'margin-bottom: -19px;';
    }
}`;

const Table = Styled.table`
    white-space: nowrap;
    width: 100%;
    border-collapse: collapse;
    border-spacing: 0;
`;

const Td = Styled.td`
    padding: 0 9px;
`;

const A = Styled.a`
    display: inline-block;
    margin: 0 9px 0 0;
    color: ${props => props.disabled ? '#777' : '#000'};
    font-size: 15px;
    line-height: 51px;
    transition: color .15s ease-out;
    text-decoration: none;
    position: relative;
    top: ${props => props.type ? '-1px' : '0px'};
    pointer-events: ${props => props.cur || props.disabled ? 'none' : 'inherit'};
    box-shadow: ${props => {
        if (props.cur) {
            return props.type ? 'inset 0 2px 0 #000' : 'inset 0 -2px 0 #e00';
        }

        return 'inherit';
    }};
`;

class SubNavigation extends React.Component {
    handleClick(i) {
        return function (e) {
            this.props.onClick(i, e);
        }.bind(this);
    }

    render() {
        return this.props.tabs ?
            (
                <Div type={this.props.type === 'top'}>
                    <Table>
                        <tbody>
                            <tr>
                                {
                                    this.props.tabs.map((item, i) => {
                                        return (<Td
                                            key={i}
                                            data-nav-target={item.title}
                                            onClick={item.active === false ? function () {} : this.handleClick(i)}
                                            >
                                            <A
                                                href="#"
                                                cur={this.props.active === i}
                                                disabled={item.active === false}
                                                type={this.props.type === 'top'}
                                                >
                                                {item.title.slice(0, 1).toUpperCase() + item.title.slice(1)}
                                                {item.counters !== undefined && <span>{' '}{item.counters}</span>}
                                            </A>
                                        </Td>);
                                    })
                                }
                                <td className="c c_max"/>
                            </tr>
                        </tbody>
                    </Table>
                </Div>
            ) :
            null;
    }
}

SubNavigation.propTypes = {
    type: PropTypes.string,
    tabs: PropTypes.array,
    active: PropTypes.number,
    onClick: PropTypes.func
};

SubNavigation.defaultProps = {
    onClick: () => {}
};

module.exports = SubNavigation;
