import test from 'ava';
import React from 'react';
import { mount } from 'enzyme';
import sinon from 'sinon';

import SubNavigation from './index';

test('should be rendered with custom content', t => {
    const tabs = ['nice', 'cool', 'awesome'].map(item => {
        return {
            title: item,
            path: `/${item}/42`
        };
    });

    const navigation = mount(<SubNavigation tabs={tabs}/>);

    t.is(navigation.type(), SubNavigation);

    const links = navigation.find('a');

    t.is(links.length, 3);

    links.forEach((link, i) => {
        t.is(link.text(), tabs[i].title.slice(0, 1).toUpperCase() + tabs[i].title.slice(1));
    });
});

test('should handle event with correct arguments', t => {
    const tabs = ['nice', 'cool', 'awesome'].map(item => {
        return {
            title: item,
            path: `/${item}/42`
        };
    });

    const handler = sinon.spy();

    const navigation = mount(<SubNavigation
        tabs={tabs}
        onClick={handler}
        />);

    t.is(navigation.type(), SubNavigation);

    const tds = navigation.find('td[data-nav-target]');

    tds.forEach((td, i) => {
        td.simulate('click');
        t.is(handler.callCount, i + 1);
    });
});

test('should render type', t => {
    const tabs = ['nice', 'cool', 'awesome'].map(item => {
        return {
            title: item,
            path: `/${item}/42`
        };
    });

    let navigation = mount(<SubNavigation
        tabs={tabs}
        type={'top'}
        />);

    t.is(navigation.type(), SubNavigation);
    t.is(navigation.find('div').props().type, true);

    navigation = mount(<SubNavigation
        tabs={tabs}
        type={'wrong-type'}
        />);

    t.is(navigation.type(), SubNavigation);
    t.is(navigation.find('div').props().type, false);
});
