import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { isEmpty, filter, includes, valuesIn } from 'lodash';
import qs from 'querystring';

import DataListContainer from '../../DataListContainer';

class SuggestGroup extends Component {
    constructor(props) {
        super(props);

        this.state = {
            variants: {}
        };
    }

    shouldComponentUpdate(newProps) {
        return !isEmpty(newProps.data);
    }

    componentWillReceiveProps(newProps) {
        const params = valuesIn(qs.parse(location.search)) || [];

        if (this.props.value !== newProps.value &&
            newProps.value &&
            !includes(params, newProps.value)
        ) {
            this.updateData(newProps.value);
        }
    }

    updateData(value) {
        if (!value) {
            return this.setState({
                variants: {}
            });
        }

        this.setState({
            variants: {
                data: filter(this.props.data, item => {
                    return includes(item.name, value.toLowerCase()) ||
                        includes(item.name, value.toUpperCase());
                }).slice(0, 7)
            }
        });
    }

    onError(err) {
        this.setState({
            variants: {}
        });
        console.warn(err); // eslint-disable-line
    }

    prepare(variants) {
        const result = [];
        const { data = [] } = variants;

        data.forEach(val => {
            return result.push({
                value: val.name,
                desc: val.name,
                title: 'User groups'
            });
        });

        return result;
    }

    render() {
        const { variants } = this.state;
        const { value, onChange, size, placeholder, name } = this.props;

        return (
            <DataListContainer
                size={size}
                placeholder={placeholder}
                name={name}
                onChange={onChange}
                value={value}
                data={this.prepare(variants)}
                />
        );
    }
}

SuggestGroup.defaultProps = {
    data: []
};

SuggestGroup.propTypes = {
    onChange: PropTypes.func,
    value: PropTypes.string,
    data: PropTypes.oneOfType([
        PropTypes.array,
        PropTypes.object
    ]),
    size: PropTypes.string,
    placeholder: PropTypes.string,
    name: PropTypes.string
};

module.exports = SuggestGroup;
