import React from 'react';

import Suggest from '../../Suggest';
import DataListContainer from '../../DataListContainer';

class SuggestMulti extends Suggest {
    constructor(props) {
        super(props);

        this.state = {
            variants: [],
            value: ''
        };

        this._multi = true;

        this.handleChange = this.handleChange.bind(this);
    }

    handleChange(e) {
        let { value } = e.target;

        value = value.replace(/[,]*/g, '');

        this.setState({
            value
        });

        this.updateData(value);
    }

    render() {
        const selected = this.props.value;
        const { onChange, onToggle, name, placeholder, togglerValue } = this.props;
        const { variants, value } = this.state;

        return (
            <DataListContainer
                name={name}
                mix={this.mix || ''}
                placeholder={placeholder}
                multi
                value={value}
                togglerValue={togglerValue}
                selected={selected}
                data={this.prepare(variants)}
                onChange={this.handleChange}
                onSelectChange={onChange}
                onTogglerChange={onToggle}
                />
        );
    }
}

module.exports = SuggestMulti;
