import React from 'react';
import b_ from 'b_';

import Suggest from '../Suggest';
import SuggestMulti from '../Suggest/Multi';

const block_ = b_.with('abc-suggest');
const suggestABCFabric = suggest => class SuggestAbc extends suggest {
    get mix() {
        return 'abc-suggest';
    }

    getUrl({ value }) {
        if (typeof value !== 'string') {
            value = '';
        }

        const host = '//search.yandex-team.ru/suggest/';
        const _query = `?version=2&layers=groups&groups.per_page=20&groups.query=s_type:service&text=${value}`;

        return host + _query;
    }

    getHeader() {
        return {
            withCredentials: true
        };
    }

    processingResult(res) {
        return res.groups.result;
    }

    updateData(value) {
        const result = [];
        const _resources = this._resources;

        if (!value) {
            return this.setState({
                variants: result
            });
        }

        this.props.onLoadingStart();

        _resources.forEach((resource, order) => {
            const { url, name, paramName, title } = resource;

            this.fetch({ url, name, paramName, value }, data => {
                result.push({
                    order,
                    data,
                    title
                });

                this.setState({
                    variants: result
                });
                this.props.onLoadingEnd();
            });
        });
    }

    prepare(variants) {
        const result = [];

        variants.forEach(variant => {
            const { data } = variant;

            data.sort((a, b) => a.slug.length > b.slug.length).forEach(item => {
                result.push({
                    value: item.slug.replace('svc_', ''),
                    desc: this.getAbcItem(item)
                });
            });
        });

        return result;
    }

    getAbcItem(item) {
        return (
            <div key={item.slug} className={block_('item')}>
                <div className={block_('info')}>
                    <div className={block_('name')}>
                        {item.slug.replace('svc_', '')}
                    </div>
                    <div className={block_('description')}>
                        {item.title}
                    </div>
                </div>
            </div>
        );
    }
};

const SuggestAbc = suggestABCFabric(Suggest);
const SuggestAbcMulti = suggestABCFabric(SuggestMulti);

module.exports = {
    SuggestAbcMulti,
    SuggestAbc,
    default: SuggestAbc
};

