import Suggest from '../Suggest';
import SuggestMulti from '../Suggest/Multi';

const suggestGroupFabric = function (suggest) {
    return class SuggestGroupClass extends suggest {
        get mix() {
            return 'groups-suggest';
        }

        getUrl({ value }) {
            if (typeof value !== 'string') {
                value = '';
            }

            return `/api/v1.0/suggest/quicksearch/${value}?limit=6`;
        }

        updateData(value) {
            const result = [];
            const _resources = this._resources;

            if (!value) {
                return this.setState({
                    variants: result
                });
            }

            this.props.onLoadingStart();

            _resources.forEach((resource, order) => {
                const { url, name, paramName, title } = resource;

                this.fetch({ url, name, paramName, value }, data => {
                    data = data.filter(item => item.group).map(item => item.group).sort((a, b) => a.name.length > b.name.length);

                    result.push({
                        order,
                        data,
                        title
                    });

                    this.setState({
                        variants: result
                    });
                    this.props.onLoadingEnd();
                });
            });
        }

        getHeader() {
            return {};
        }

        processingResult(res) {
            return res;
        }

        prepare(variants) {
            const result = [];

            variants.forEach(variant => {
                const { data } = variant;

                data.forEach(item => {
                    if (item && item.name) {
                        result.push({
                            value: item.name,
                            desc: item.name
                        });
                    }
                });
            });

            return result;
        }
    };
};

const SuggestGroup = suggestGroupFabric(Suggest);
const SuggestGroupMulti = suggestGroupFabric(SuggestMulti);

module.exports = {
    SuggestGroupMulti,
    SuggestGroup,
    default: SuggestGroup
};
