import React from 'react';
import b_ from 'b_';

import Suggest from '../Suggest';
import SuggestMulti from '../Suggest/Multi';

const block_ = b_.with('rb-suggest');
const suggestRBFabric = suggest => class SuggestRb extends suggest {
    get mix() {
        return 'rb-suggest';
    }

    getUrl({ value }) {
        if (typeof value !== 'string') {
            value = '';
        }

        const host = '//a.yandex-team.ru/api/group';
        const _query = `?name=${value}`;

        return host + _query;
    }

    getHeader() {
        return {
            withCredentials: true
        };
    }

    processingResult(res) {
        return res;
    }

    updateData(value) {
        const result = [];
        const _resources = this._resources;

        if (!value) {
            return this.setState({
                variants: result
            });
        }

        this.props.onLoadingStart();

        _resources.forEach((resource, order) => {
            const { url, name, paramName, title } = resource;

            this.fetch({ url, name, paramName, value }, data => {
                result.push({
                    order,
                    data,
                    title
                });

                this.setState({
                    variants: result
                });
                this.props.onLoadingEnd();
            });
        });
    }

    prepare(variants) {
        const result = [];

        variants.forEach(variant => {
            const { data } = variant;

            data.slice(0, 5).forEach(item => {
                result.push({
                    value: item.name,
                    desc: this.getRbItem(item)
                });
            });
        });

        return result;
    }

    getRbItem(item) {
        return (
            <div key={item.name} className={block_('item')}>
                <div className={block_('info')}>
                    <div className={block_('name')}>
                        {item.name}
                    </div>
                </div>
            </div>
        );
    }
};

const SuggestRb = suggestRBFabric(Suggest);
const SuggestRbMulti = suggestRBFabric(SuggestMulti);

module.exports = {
    SuggestRbMulti,
    SuggestRb,
    default: SuggestRb
};
