import Suggest from '../Suggest';
import SuggestMulti from '../Suggest/Multi';

const suggestSemaphoreFabric = function (suggest) {
    return class SuggestTag extends suggest {
        getUrl({ value }) {
            if (typeof value !== 'string') {
                value = '';
            }

            return `/api/v1.0/semaphore?limit=6&name=${value}`;
        }

        getHeader() {
            return {};
        }

        processingResult(res) {
            return res;
        }

        updateData(value) {
            const result = [];
            const _resources = this._resources;

            if (!value) {
                return this.setState({
                    variants: result
                });
            }

            this.props.onLoadingStart();

            _resources.forEach((resource, order) => {
                const { url, name, paramName, title } = resource;

                this.fetch({ url, name, paramName, value }, data => {
                    data = data.items.map(({ name }) => name);

                    result.push({
                        order,
                        data,
                        title
                    });

                    this.setState({
                        variants: result
                    });
                    this.props.onLoadingEnd();
                });
            });
        }

        prepare(variants) {
            const result = [];

            variants.forEach(variant => {
                const { data } = variant;

                data.forEach(semaphore => {
                    result.push({
                        value: semaphore,
                        desc: semaphore
                    });
                });
            });

            return result;
        }
    };
};

const SuggestSemaphore = suggestSemaphoreFabric(Suggest);
const SuggestSemaphoreMulti = suggestSemaphoreFabric(SuggestMulti);

module.exports = {
    SuggestSemaphoreMulti,
    SuggestSemaphore,
    default: SuggestSemaphore
};
