import React from 'react';
import b_ from 'b_';

import Suggest from '../Suggest';
import SuggestMulti from '../Suggest/Multi';

const block_ = b_.with('staff-suggest');
const suggestStaffFabric = suggest => class SuggestStaff extends suggest {
    get mix() {
        return 'staff-suggest';
    }

    getUrl({ value }) {
        if (typeof value !== 'string') {
            value = '';
        }

        const host = '//search.yandex-team.ru/suggest/';
        const _query = `?version=2&layers=groups&groups.query=s_type:department&text=${value}`;

        return host + _query;
    }

    getHeader() {
        return {
            withCredentials: true
        };
    }

    processingResult(res) {
        return res.groups.result;
    }

    updateData(value) {
        const result = [];
        const _resources = this._resources;

        if (!value) {
            return this.setState({
                variants: result
            });
        }

        this.props.onLoadingStart();

        _resources.forEach((resource, order) => {
            const { url, name, paramName, title } = resource;

            this.fetch({ url, name, paramName, value }, data => {
                result.push({
                    order,
                    data,
                    title
                });

                this.setState({
                    variants: result
                });
                this.props.onLoadingEnd();
            });
        });
    }

    prepare(variants) {
        const result = [];

        variants.forEach(variant => {
            const { data } = variant;

            data.forEach(item => {
                result.push({
                    value: item.slug,
                    desc: this.getStaffItem(item)
                });
            });
        });

        return result;
    }

    getStaffItem(item) {
        return (
            <div key={item.id} className={block_('item')}>
                <div className={block_('info')}>
                    <div className={block_('name')}>
                        {item.slug}
                    </div>
                    <div className={block_('description')}>
                        {item.title}
                    </div>
                </div>
            </div>
        );
    }
};

const SuggestStaffGroup = suggestStaffFabric(Suggest);
const SuggestStaffGroupMulti = suggestStaffFabric(SuggestMulti);

module.exports = {
    SuggestStaffGroupMulti,
    SuggestStaffGroup,
    default: SuggestStaffGroup
};

