import React from 'react';

import Suggest from '../Suggest';
import SuggestMulti from '../Suggest/Multi';

const suggestTagFabric = function (suggest) {
    return class SuggestTag extends suggest {
        getUrl({ value }) {
            if (typeof value !== 'string') {
                value = '';
            }

            return `/api/v1.0/suggest/task/tags/${value}`;
        }

        getHeader() {
            return {};
        }

        processingResult(res) {
            return res;
        }

        prepare(variants) {
            const result = [];

            variants.forEach(variant => {
                const { data } = variant;

                data.forEach(tag => {
                    result.push({
                        value: tag,
                        desc: <span className={'datalist datalist__selected'}>{tag}</span>
                    });
                });
            });

            return result;
        }
    };
};

const SuggestTag = suggestTagFabric(Suggest);
const SuggestTagMulti = suggestTagFabric(SuggestMulti);

module.exports = {
    SuggestTagMulti,
    SuggestTag,
    default: SuggestTag
};
