import React from 'react';
import b_ from 'b_';
import { stringify } from 'querystring';

import Suggest from '../Suggest';
import SuggestMulti from '../Suggest/Multi';

const block_ = b_.with('user-suggest');
const suggestUserFabric = suggest => class SuggestUser extends suggest {
    getUrl({ value }) {
        if (typeof value !== 'string') {
            value = '';
        }

        const host = '//api.staff.yandex-team.ru/v3/persons?';
        const params = {
            'official.is_dismissed': 'false',
            _limit: 5,
            _fields: 'login,id,name,department_group',
            _sort: 'official.is_robot,login'
        };
        const _query = `&_query=login==regex(%27^${value}.*%27)`;

        return host + stringify(params) + _query;
    }

    getHeader() {
        return {
            withCredentials: true
        };
    }

    processingResult(res) {
        return res.result;
    }

    updateData(value) {
        const result = [];
        const _resources = this._resources;

        if (!value) {
            return this.setState({
                variants: result
            });
        }

        this.props.onLoadingStart();

        _resources.forEach((resource, order) => {
            const { url, name, paramName, title } = resource;

            this.fetch({ url, name, paramName, value }, data => {
                result.push({
                    order,
                    data,
                    title
                });

                this.setState({
                    variants: result
                });
                this.props.onLoadingEnd();
            });
        });
    }

    prepare(variants) {
        const result = [];

        variants.forEach(variant => {
            const { data } = variant;

            data.forEach(user => {
                result.push({
                    value: user.login,
                    desc: this.getUserItem(user)
                });
            });
        });

        return result;
    }

    getUserItem(user) {
        return (
            <div key={user.login} className={block_('item')}>
                <div className={block_('info')}>
                    <div className={block_('name')}>
                        {user.login}
                    </div>
                </div>
            </div>
        );
    }
};

const SuggestUser = suggestUserFabric(Suggest);
const SuggestUserMulti = suggestUserFabric(SuggestMulti);

module.exports = {
    SuggestUserMulti,
    SuggestUser,
    default: SuggestUser
};

