import React from 'react';
import Styled from 'styled-components';
import PropTypes from 'prop-types';

const OuterWrapper = Styled.div`
    background: #fff;
    box-shadow: inset 0 0 0 1px rgba(0, 0, 0, 0.1);
    box-sizing: border-box;
    padding: 20px;
`;

const InnerWrapper = Styled.div`
    padding: 20px 0;
`;

class TabContentWrapper extends React.Component {
    render() {
        const { children } = this.props;

        if (!children) {
            return null;
        }

        return (
            <OuterWrapper>
                <InnerWrapper>
                    {children}
                </InnerWrapper>
            </OuterWrapper>
        );
    }
}

TabContentWrapper.propTypes = {
    children: PropTypes.any
};

module.exports = TabContentWrapper;
