import test from 'ava';
import React from 'react';
import { mount } from 'enzyme';

import TabContentWrapper from './index';

test('should be rendered with custom content', t => {
    const wrapper = mount(<TabContentWrapper>
        <span>42</span>
    </TabContentWrapper>);

    t.is(wrapper.type(), TabContentWrapper);
    t.is(wrapper.find('span').length, 1);
    t.is(wrapper.find('span').text(), '42');
});

test('should not be rendered without any children passed', t => {
    const wrapper = mount(<TabContentWrapper/>);

    t.is(wrapper.html(), null);
});
