import React, { Component } from 'react';
import PropTypes from 'prop-types';
import b_ from 'b_';

import { get } from 'lodash';

import Extensible from '../../../Extensible';

import i18n from '../../../i18n';

export class NewTag extends Component {
    constructor(props) {
        super(props);

        this._block = b_.with('new-tag');
        this._texts = get(i18n, ['tasks', 'tags']);

        this.handleAddTag = this.handleAddTag.bind(this);
    }

    handleAddTag({ value }) {
        this.props.onAdd(value);
    }

    render() {
        return (
            <div className={this._block()}>
                <Extensible
                    mix={this._block('add')}
                    title={this._texts.new}
                    placeholder={this._texts.placeholder}
                    pattern={'^[^/]+$'}
                    onAdd={this.handleAddTag}
                    />
            </div>
        );
    }
}

NewTag.propTypes = {
    onAdd: PropTypes.func
};

NewTag.defaultProps = {
    onAdd: PropTypes.func
};

module.exports = NewTag;
