import React, { Component } from 'react';
import PropTypes from 'prop-types';
import router from '../../../router';

import NewTag from './NewTag';
import Tags from '../../common/Tags';

export class TaskTags extends Component {
    constructor(props) {
        super(props);

        this.handleAddTag = this.handleAddTag.bind(this);
        this.handleSelect = this.handleSelect.bind(this);
        this.handleRemove = this.handleRemove.bind(this);
    }

    componentDidMount() {
        this.props.applyTags({
            tags: this.props.tags,
            id: this.props.id
        });
    }

    handleAddTag(tag) {
        tag = tag.replace(/\s/g, '_').toLowerCase();

        if (tag) {
            this.props.upload({ tags: [...this.props.tags, tag], id: this.props.id });
            this.props.onTagsChange([...this.props.tags, tag]);
        }
    }

    handleSelect(tag) {
        const url = this.props.namespace;

        if (url) {
            router.navigate(url.replace('%%', tag), { trigger: true });
        }
    }

    handleRemove(tag) {
        if (tag) {
            this.props.remove({ tag, id: this.props.id });

            const tagIndex = this.props.tags.indexOf(tag);

            if (tagIndex !== -1) {
                this.props.onTagsChange([
                    ...this.props.tags.slice(0, tagIndex),
                    ...this.props.tags.slice(tagIndex + 1)
                ]);
            }
        }
    }

    render() {
        const isEditable = this.props.rights === 'write';

        if (!this.props.combinedTags) {
            return null;
        }

        return (
            <div className={'commit__tags'}>
                <Tags
                    tags={this.props.combinedTags}
                    onSelect={this.handleSelect}
                    onRemove={this.handleRemove}
                    removable={isEditable}
                    />
                {isEditable ? <NewTag onAdd={this.handleAddTag}/> : null}
            </div>
        );
    }
}

TaskTags.defaultProps = {
    rights: '',
    namespace: '/tasks/?tags=%%',
    applyTags: () => {},
    onTagsChange: () => {},
    tags: []
};

TaskTags.propTypes = {
    namespace: PropTypes.string,
    tags: PropTypes.array,
    combinedTags: PropTypes.array,
    id: PropTypes.number,
    upload: PropTypes.func,
    remove: PropTypes.func,
    applyTags: PropTypes.func,
    rights: PropTypes.string,
    onTagsChange: PropTypes.func
};

module.exports = TaskTags;
