import { connect } from 'react-redux';

const API = require('../../../api');

import TaskTags from './Tags';

function mapStateToProps(state, props) {
    return {
        combinedTags: state.tags[props.id]
    };
}

function mapDispatchToProps(dispatch) {
    return {
        upload: payload => dispatch(API.tags.add(payload)),
        remove: payload => dispatch(API.tags.remove(payload)),
        applyTags: payload => dispatch(API.tags.applyTags(payload))
    };
}

module.exports = connect(mapStateToProps, mapDispatchToProps)(TaskTags);
