import React from 'react';
import Styled from 'styled-components';
import PropTypes from 'prop-types';

const Login = Styled.span.attrs({
    className: 'user-login'
})`
    transition: color 0.1s ease-out;
    text-decoration: none;
    color: #000;
    margin-right: 4px;

    &:hover {
        color: #e00;
    }

    &:first-letter {
        color: #e00;
    }
`;

class UserLogin extends React.PureComponent {
    render() {
        return (
            this.props.login ?
                <Login>{this.props.login}</Login> :
                null
        );
    }
}

UserLogin.propTypes = {
    login: PropTypes.string
};

module.exports = UserLogin;
