import test from 'ava';
import React from 'react';
import { shallow } from 'enzyme';

import UserLogin from './index';

test('should not be rendered without login prop', t => {
    const login = shallow(<UserLogin/>);

    t.is(login.type(), null);
});

test('should be rendered with custom login', t => {
    const value = 'evilj0e';
    const login = shallow(<UserLogin login={value}/>).dive();

    t.is(login.type(), 'span');
    t.is(login.text(), value);
});
