import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import b_ from 'b_';

import { del } from '../../../api/alert';

class Alert extends Component {
    static get delay() {
        return 5000;
    }

    constructor(props) {
        super(props);

        this.handleClick = this.handleClick.bind(this);
        this._block = b_.with('alert');
        this._timers = [];
    }

    componentWillReceiveProps(newProps) {
        if (this.props.items.size !== newProps.items.size) {
            newProps.items.forEach(({ autoHide = true }, i) => {
                if (autoHide && !this._timers[i]) {
                    this._timers.push(this.deleteAfterWhile(i));
                }
            });
        }
    }

    deleteAfterWhile(i) {
        return setTimeout(() => {
            this.props.alertDel(i);
            this._timers.shift();
        }, Alert.delay);
    }

    handleClick(i) {
        return () => {
            this.props.alertDel(i);
            if (this._timers[i]) {
                clearTimeout(this._timers[i]);
                this._timers.splice(i, i + 1);
            }
        };
    }

    render() {
        const { items } = this.props;

        const Items = items.map((item, key) => {
            const errorContent = `${item.code || ''} ${item.message}`;

            return (
                <div className={this._block('item', { type: item.type })} key={key}>
                    <div className={`${this._block('legend')} markdown-body`}>{errorContent}</div>
                    <div className={this._block('close')} onClick={this.handleClick(key)}>
                        <i className="fa fa-times" aria-hidden="true"/>
                    </div>
                </div>
            );
        });

        return (
            <div className="alert">
                <div className={this._block('wrap')}>
                    {Items}
                </div>
            </div>
        );
    }
}

Alert.propTypes = {
    items: PropTypes.array,
    alertDel: PropTypes.func
};

function mapStateToProps(state) {
    return {
        items: state.alert
    };
}

function mapDispatchToProps(dispatch) {
    return {
        alertDel(payload) {
            return dispatch(del(payload));
        }
    };
}

module.exports = connect(mapStateToProps, mapDispatchToProps)(Alert);
