import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import clipboard from 'clipboard-polyfill';
import styled from 'styled-components';

import Tooltip from 'rc-tooltip';

const Btn = styled.div`
    display: inline-block;
    margin-left: 5px;
    cursor: pointer;
`;

class Copy extends PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            copied: false
        };

        this.handleClick = this.handleClick.bind(this);
        this.handleMouseOut = this.handleMouseOut.bind(this);
    }

    handleClick(e) {
        e.preventDefault();
        e.stopPropagation();

        this.setState({
            copied: true
        });

        clearTimeout(this.timer);
        clipboard.writeText(this.props.text);
    }

    handleMouseOut() {
        clearTimeout(this.timer);

        this.timer = setTimeout(() => {
            this.setState({
                copied: false
            });
        }, 300);
    }

    render() {
        const { children, tooltipHover, tooltipClick } = this.props;
        const tooltip = this.state.copied ? tooltipClick : tooltipHover;

        return (
            <Tooltip placement="top" overlay={tooltip}>
                <Btn onMouseOut={this.handleMouseOut} onClick={this.handleClick}>
                    {children}
                </Btn>
            </Tooltip>
        );
    }
}

Copy.propTypes = {
    text: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
    tooltipHover: PropTypes.string,
    tooltipClick: PropTypes.string,
    children: PropTypes.any
};

Copy.defaultProps = {
    tooltipHover: 'Copy to clipboard',
    tooltipClick: 'Copied!'
};

module.exports = Copy;
