import React, { Component } from 'react';
import { connect } from 'react-redux';
import PropTypes from 'prop-types';
import { get } from 'lodash';

import API from '../../../api';

import { YSelect, YOption } from 'y-components';

class OwnerSelector extends Component {
    constructor(props) {
        super(props);

        this.handleChange = this.handleChange.bind(this);
    }

    componentDidMount() {
        if (!this.props.userGroups.length) {
            this.props.fetchUserGroups();
        }
    }

    handleChange(e) {
        this.props.onChange(e);
    }

    render() {
        const { name, mix, value } = this.props;

        return (
            <YSelect
                size="s"
                theme="normal"
                rows={4}
                onChange={this.handleChange}
                name={name}
                mix={mix}
                >
                <YOption value="" selected={!value}/>
                {
                    this.props.userGroups.map(({ name }, i) => <YOption value={name} key={i} selected={name === value}>{name}</YOption>)
                }
            </YSelect>
        );
    }
}

OwnerSelector.propTypes = {
    name: PropTypes.string,
    value: PropTypes.string,
    mix: PropTypes.string,
    onChange: PropTypes.func,
    userGroups: PropTypes.array,
    fetchUserGroups: PropTypes.func
};

OwnerSelector.defaultProps = {
    onChange: () => {},
    mix: 'y-select_type_wide'
};

function mapStateToProps(state) {
    return {
        userGroups: get(state, ['user', 'groups'], [])
    };
}

function mapDispatchToProps(dispatch) {
    return {
        fetchUserGroups() {
            return dispatch(API.user.fetchGroupsList());
        }
    };
}

module.exports = connect(mapStateToProps, mapDispatchToProps)(OwnerSelector);
