import React, { PureComponent } from 'react';
import styled from 'styled-components';
import PropTypes from 'prop-types';

import router from '../../../../router';

const LabelWrapper = styled.a`
    background-color: transparent;
    color: #3535cc !important;
    border: 1px solid #9c9ce6;
    display: inline-block;
    cursor: pointer;
    transition: color 0.15s ease-out;
    text-decoration: none;
    font-weight: bold;
    white-space: nowrap;
    word-break: keep-all;
    font-size: 10px;
    line-height: 15px;
    height: 15px;
    text-transform: uppercase;
    letter-spacing: 1px;
    padding: 0 3px 0 5px;
    margin-right: 3px;
`;

class Label extends PureComponent {
    constructor(props) {
        super(props);

        this.handleClick = this.handleClick.bind(this);
    }

    getUrl(tag) {
        if (tag) {
            return `/tasks/?tags=${tag}`;
        }

        return '';
    }

    handleClick(e) {
        e.preventDefault();
        e.stopPropagation();

        const tag = e.target.innerText.toLowerCase();
        const url = this.getUrl(tag);

        if (url) {
            router.navigate(url, { trigger: true });
            this.props.onClick(url);
        }

        return false;
    }

    render() {
        const { tag } = this.props;

        if (!tag) {
            return null;
        }

        return <LabelWrapper href={this.getUrl(tag)} onClick={this.handleClick}>{tag}</LabelWrapper>;
    }
}

Label.propTypes = {
    tag: PropTypes.string,
    onClick: PropTypes.func
};

Label.defaultProps = {
    tag: '',
    onClick: () => {}
};

module.exports = Label;
