import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { get } from 'lodash';
import b_ from 'b_';

import { YPopup, YButton } from 'y-components';

import i18n from '../../../i18n';

class Tag extends Component {
    constructor(props) {
        /* eslint max-statements: [1, 11] */

        super(props);

        this._block = b_.with('tags-list');
        this._popup = b_.with('delete-tag');
        this._texts = get(i18n, ['tasks', 'tags']);

        this.state = {};

        this.refPopupTarget = ref => {
            this._target = ref;
        };

        this.renderDelete = this.renderDelete.bind(this);
        this.handleShowPopup = this.handleShowPopup.bind(this);
        this.handleHidePopup = this.handleHidePopup.bind(this);
        this.handleSelectTag = this.handleSelectTag.bind(this);
        this.handleDeleteTag = this.handleDeleteTag.bind(this);
    }

    componentDidMount() {
        this.setState({
            popupTarget: this._target
        });
    }

    handleShowPopup() {
        this.setState({ popupVisible: true });
    }

    handleHidePopup() {
        this.setState({ popupVisible: false });
    }

    handleSelectTag(e) {
        e.stopPropagation();

        this.props.onSelect(this.props.children);
    }

    handleDeleteTag() {
        this.props.onDelete(this.props.children);
        this.handleHidePopup();
    }

    renderDelete() {
        if (!this.props.removable) {
            return null;
        }

        return (
            <div className={this._block('delete-wrap')}>
                <div
                    ref={this.refPopupTarget}
                    onClick={this.handleShowPopup}
                    className={this._block('delete-item')}
                    >
                    &#10005;
                </div>
                <YPopup
                    target={this.state.popupTarget}
                    visible={this.state.popupVisible}
                    onShouldClose={this.handleHidePopup}
                    >
                    <div className={this._popup('message')}>
                        {this._texts.remove} ({this.props.children})?
                    </div>
                    <div className={this._popup('controls')}>
                        <YButton
                            size={'s'}
                            onClick={this.handleHidePopup}
                            >
                            {this._texts.cancel}
                        </YButton>
                        <YButton
                            size={'s'}
                            theme={'action'}
                            onClick={this.handleDeleteTag}
                            >
                            {this._texts.delete}
                        </YButton>
                    </div>
                </YPopup>
            </div>
        );
    }

    render() {
        const { children, removable } = this.props;

        return (
            <li className={this._block('item', { removable })}>
                <span className={this._block('title')} onClick={this.handleSelectTag}>{children}</span>
                {this.renderDelete()}
            </li>
        );
    }
}

Tag.propTypes = {
    children: PropTypes.string,
    removable: PropTypes.bool,
    onSelect: PropTypes.func,
    onDelete: PropTypes.func
};

module.exports = Tag;
