import React, { Component } from 'react';
import PropTypes from 'prop-types';
import b_ from 'b_';

import Tag from './Tag';

export class Tags extends Component {
    constructor(props) {
        super(props);
        this._block = b_.with('tags-list');

        this.handleSelect = this.handleSelect.bind(this);
        this.handleDelete = this.handleDelete.bind(this);
    }

    handleSelect(tag) {
        this.props.onSelect(tag);
    }

    handleDelete(tag) {
        this.props.onRemove(tag);
    }

    render() {
        const { tags, removable } = this.props;

        if (!tags || tags.length < 1) {
            return null;
        }

        return (
            <ul className={this._block()}>
                {tags.map((tag, key) => (
                    <Tag
                        key={key}
                        removable={removable}
                        onSelect={this.handleSelect}
                        onDelete={this.handleDelete}
                        >
                        {tag}
                    </Tag>
                ))}
            </ul>
        );
    }
}

Tags.propTypes = {
    tags: PropTypes.array,
    removable: PropTypes.bool,
    onSelect: PropTypes.func,
    onRemove: PropTypes.func
};

Tags.defaultProps = {
    onSelect: () => {},
    onRemove: () => {}
};

module.exports = Tags;
