const _ = require('underscore');
const Events = require('backbone').Events;

const ReactBackbone = {
    listenToProps(props) {
        _.each(this.updateOnProps, function (events, propName) {
            switch (events) {
                case 'collection':
                    events = 'add remove reset sort change';
                    break;
                case 'model':
                    events = 'change';
                    break;
                default:
            }
            this.listenTo(props[propName], events, function () {
                this.forceUpdate();
            });
        }, this);
    },

    componentDidMount() {
        this.listenToProps(this.props);
    },

    componentWillReceiveProps(nextProps) {
        this.stopListening();
        this.listenToProps(nextProps);
    },

    componentWillUnmount() {
        this.stopListening();
    }
};

_.extend(ReactBackbone, Events);

module.exports = ReactBackbone;
