import test from 'ava';

import format from './format';

test('should format correctly', t => {
    t.is(format(1024, '0.00 b'), '1.00 KB');
    t.is(format(512, '0.00 b'), '512.00 B');
    t.is(format(0, '0 b'), '0 B');
    t.is(format(-100, '0.00 b'), '-100.00 ');
    t.is(format(1024), '1,024');
    t.is(format(1024, 'kek'), '1024');
    t.is(format('1024', 'kek'), '1024');
});

test('should format empty and mixed data', t => {
    t.is(format('kek', 'kek'), '0');
    t.is(format('kek', '0.0'), '0.0');
    t.is(format('kek1', '0.0'), '1.0');
});
