// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const LayoutConfig = require('../application/config/layoutConfig');
const app = require('../app');
const router = require('../router');
const loader = require('../views/loader');
const resources = require('../resources/index');
const error = require('../error');
const rum = require('../helpers/utils/rum');

router.on('route:admin', function (action, key, sub) {
    /* eslint max-statements: [1, 21] */

    rum.setPage('admin');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:clients:' + action;
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = 'Settings | Sandbox';

    this.unbindRouteRelatedEvents();

    const adminPageConfig = {
        vault: {
            resourceMethod: 'manageVaults',
            pageTitle: 'Manage vaults',
            listPage: 'MANAGE_VAULTS'
        },
        semaphores: {
            resourceMethod: 'manageSemaphores',
            pageTitle: 'Manage semaphores',
            singlePage: 'SEMAPHORE',
            listPage: 'MANAGE_SEMAPHORES'
        },
        groups: {
            resourceMethod: 'manageGroups',
            pageTitle: 'Manage user groups',
            singlePage: 'GROUP',
            listPage: 'MANAGE_GROUPS'
        },
        'bind-tasks': {
            resourceMethod: 'taskTypeBindings',
            pageTitle: 'Bind task types to hosts',
            listPage: 'BIND_TASK_TYPES'
        },
        'service-threads': {
            resourceMethod: 'serviceThreadsData',
            pageTitle: 'Service threads monitoring',
            listPage: 'SERV_THREADS'
        },
        'db-state': {
            resourceMethod: 'shardsData',
            pageTitle: 'DB state monitoring',
            listPage: 'DB_STATE'
        },
        'task-types': {
            resourceMethod: 'taskTypesData',
            pageTitle: 'Manage task types',
            listPage: 'TASK_TYPES'
        }
    };

    if (!adminPageConfig[action]) {
        app.reqres.request('ERR_TRACE', xhr);
        error.showErrPage(xhr);

        return;
    }

    document.title = (adminPageConfig[action].pageTitle + ' | Sandbox');

    loader.show();

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig(
        adminPageConfig[action][key ? 'singlePage' : 'listPage'],
        {
            key,
            sub
        }
    ));

    this.showBasicLayout(resourceLocator);

    resources[adminPageConfig[action].resourceMethod]({ user: {}}, resourceLocator)
        .done(() => {
            appRouter.showContentLayout();

            loader.hide();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
