// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const LayoutConfig = require('../application/config/layoutConfig');
const app = require('../app');
const router = require('../router');
const loader = require('../views/loader');
const resources = require('../resources');
const error = require('../error');
const rum = require('../helpers/utils/rum');

router.on('route:clients', function () {
    /* eslint max-statements: [1, 18] */

    rum.setPage('clients');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:clients';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('Clients | Sandbox');

    this.unbindRouteRelatedEvents();

    loader.show();

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();
    const pageProps = router.parseQueryString(window.location.search);

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('CLIENTS'));

    this.showBasicLayout(resourceLocator);

    resources
        .clientsMonitoring({
            user: {},
            clients: _.extend({}, (pageProps || {})),
            task: {}
        }, resourceLocator)
        .done(() => {
            appRouter.showContentLayout();

            loader.hide();
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
