/* eslint max-statements: [1, 16] */
/* eslint complexity: [1, 16] */

const Raven = require('raven-js');

const _500ErrorPageDescription = require('../views/components/infoPanels/tpl/500ErrorPageDescription.hbs');
const _404ErrorPageDescription = require('../views/components/infoPanels/tpl/404ErrorPageDescription.hbs');
const Layout = require('../views/layouts/BasicLayout');
const CoreApplication = require('../application/CoreApplication');
const app = require('../app');
const router = require('../router');
const loader = require('../views/loader');
// eslint-disable-next-line no-unused-vars
const error = require('../error');
const rum = require('../helpers/utils/rum');

router.on('route:error', function () {
    rum.setPage('error');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:error';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('ERROR | Sandbox');

    this.unbindRouteRelatedEvents();

    loader.show();

    const errObj = app.reqres.request('ERR_XHR_OBJ');
    const LayoutConfig = require('../application/config/layoutConfig');
    const appResources = new CoreApplication({
        pageProps: LayoutConfig.getPageConfig('ERROR')
    });

    app.content.close();
    app.content.show(new Layout({
        model: appResources,
        showHeader: false,
        contentOptions: router.parseErrorParams(errObj)
    }));

    loader.hide();
    app.reqres.request('ERR_XHR_OBJ', null);

    app.initMetric();
});

router.parseErrorParams = function (errObj) {
    const statusCode = ((errObj.xhr && errObj.xhr.status) || (errObj && errObj.status));
    const xhr = errObj.xhr || errObj;

    Raven.captureMessage('GRANNY', {
        extra: {
            request: xhr.requestURL,
            status: statusCode,
            statusText: xhr.statusText
        },
        tags: {
            request: xhr.requestURL,
            status: statusCode,
            statusText: xhr.statusText
        }
    });

    const constructTrace = function () {
        const trace = app.reqres.request('ERR_TRACE') || errObj;
        let constructedTrace = '';

        if (trace) {
            constructedTrace = trace && typeof trace === 'string' ?
                trace : (
                    (trace && trace.requestURL ? ('URL: ' + trace.requestURL + '</br>') : '') +
                    (trace && trace.name ? ('Error type: ' + trace.name + '</br>') : '') +
                    (trace && trace.description ? ('Description: ' + trace.description + '</br>') : '') +
                    (
                        trace.xhr && trace.xhr.responseJSON && trace.xhr.responseJSON.reason ?
                            ('Reason: ' +
                        trace.xhr.responseJSON.reason.replace('<', '&lt;').replace('>', '&gt;') +
                        '</br>') : ''
                    ) +
                    (trace.xhr && trace.xhr.status ? ('Status: ' + trace.xhr.status + '</br>') : '')
                );
        }

        return constructedTrace;
    };

    switch (statusCode) {
        case 404:
            return {
                code: 404,
                title: 'Resource not found',
                description: _404ErrorPageDescription(),
                trace: constructTrace()
            };
        case 403:
            return {
                code: 403,
                title: 'Forbidden',
                description: _404ErrorPageDescription(),
                trace: constructTrace()
            };
        case 500:
        default:
            return {
                code: 500,
                title: 'Something went wrong',
                description: _500ErrorPageDescription(),
                trace: constructTrace()
            };
    }
};
