const app = require('../app');
const error = require('../error');
const router = require('../router');
const loader = require('../views/loader');
// eslint-disable-next-line no-unused-vars
const Layout = require('../views/layouts/BasicLayout');
const LayoutConfig = require('../application/config/layoutConfig');
const cookie = require('bemmy/src/blocks/component/cookie');
const resources = require('../resources');
const BasicCollection = require('../collection/BasicCollection');
// eslint-disable-next-line no-unused-vars
const CoreApplication = require('../application/CoreApplication');
const rum = require('../helpers/utils/rum');

router.on('route:home', function () {
    /* eslint max-statements: [1, 15] */

    rum.setPage('tasks');

    app.performance.epoch = window.performance.now();
    app.performance.internalRoute = 'route:home';
    app.trigger('trigger:route:change', app.performance.internalRoute);

    document.title = ('Tasks | Sandbox');

    this.unbindRouteRelatedEvents();

    loader.show();

    const appRouter = this;
    const resourceLocator = this.getResourceLocator();

    resourceLocator.setPageProps(LayoutConfig.getPageConfig('TASK_LIST'));

    this.showBasicLayout(resourceLocator);

    resources
        .userLastFilter({
            filterModel: require('../model/filter/FilterModel')
        })
        .done(defaultFilter => {
            const pageProps = router.parseQueryString(window.location.search);

            app.setDefaultFilter(defaultFilter);

            $.when(resources.user({}, resourceLocator), resources.taskProps({}, resourceLocator))
                .done((user, taskProps) => {
                    resourceLocator.setProps(taskProps);

                    appRouter.showFilterLayout();
                })
                .fail((err, name, description) => {
                    appRouter.showErrorPage(err, name, description);
                    error.fromXHR({ xhr: err, name, description });
                });

            // Filter for very new users
            const defaultFilterVals = defaultFilter.serializeAsUrl();

            if (Object.keys(defaultFilterVals).length <= 2 &&
                defaultFilterVals.page &&
                defaultFilterVals.pageCapacity &&
                cookie.getYandexLogin()) {
                defaultFilter.set('owner', cookie.getYandexLogin());
            }

            resources
                .home({
                    user: {},
                    tasks: _.extend(
                        {},
                        BasicCollection.parsePagingProps(pageProps),
                        defaultFilter.getFilterParams()
                    )
                }, resourceLocator)
                .done(appResources => {
                    appRouter.bindRouteRelatedEvents('home', appResources);

                    // Console.profile('CONTENT');
                    appRouter.showContentLayout();
                    // Console.profileEnd('CONTENT');

                    appResources.getTasks().trigger('filterChanged', appResources.getTasks());

                    loader.hide();
                })
                .fail((err, name, description) => {
                    appRouter.showErrorPage(err, name, description);
                    error.fromXHR({ xhr: err, name, description });
                });
        })
        .fail((err, name, description) => {
            appRouter.showErrorPage(err, name, description);
            error.fromXHR({ xhr: err, name, description });
        });

    app.initMetric();
});
